local t = Def.ActorFrame{};
if not GAMESTATE:IsCourseMode() then t[#t+1] = LoadActor("SongSearch")..{InitCommand=cmd(draworder,9999);} end
t[#t+1] = LoadActor("Banner")..{InitCommand=cmd(draworder,-1);};
t[#t+1] = StandardDecorationFromFileOptional("LifeDifficulty","LifeDifficulty");
t[#t+1] = StandardDecorationFromFileOptional("TimingDifficulty","TimingDifficulty");

t[#t+1] = Def.ActorFrame {
	CommonNormal()..{
		InitCommand=function(self) self:xy(CenterX()-130,Top()+32):zoom(0.35):halign(0) end;
		OnCommand=function(self,params)
			local rate = MetroQuad.Global.MiscOptions.RateModUsed
			rate = string.match(rate,"%d.[%d]+") or string.format("%.1f",rate)
			
			if string.len(tostring(rate)) > 7 then rate = string.format("%.5f",rate) end
			self:settext("RATE: "..rate)
		end;
		RateModChangedMessageCommand=cmd(playcommand,"On");
	};
};

t[#t+1] = Def.Actor {
	PlayerJoinedMessageCommand=function(self, params)
		if params.Player == PLAYER_1 or PLAYER_2 then 
			self:playcommand("Load");
		end
	end,
	LoadCommand=function() local TopScreen = SCREENMAN:GetTopScreen() TopScreen:SetNextScreenName("ScreenProfileLoad") TopScreen:StartTransitioningScreen("SM_GoToNextScreen") end;
};

if GAMESTATE:GetCurrentGame():GetName() == "pump" then
	t[#t+1] = Def.ActorFrame {
		Def.Quad{
			InitCommand=cmd(xy,Left(),Bottom()-40;visible,false;setsize,290,330;align,0,1;diffuse,Black();diffusealpha,0.8);
			SongChosenMessageCommand=function(self)
				self:visible(true)
			end;
			SongUnchosenMessageCommand=function(self)
				self:visible(false)
			end;
		};
	};
	t[#t+1] = LoadActor(THEME:GetPathS("","Common Start"))..{
		SongChosenMessageCommand=function(self)
			self:play()
		end;
	};
end

if GAMESTATE:GetCurrentGame():GetName() == "pump" then
	t[#t+1] = Def.ActorFrame {
		LoadFont("Common Normal") .. {
			InitCommand=cmd(x,CenterX()-284;y,CenterY()-64;zoom,0.8;uppercase,true;maxwidth,320);
			SongChosenMessageCommand=function(self)
				self:settext("Are You Ready?\nPress [Center] to Start Song!")
			end;
			SongUnchosenMessageCommand=function(self)
				self:settext("")
			end;
		};
		Def.Sprite{
			InitCommand=cmd(x,CenterX()-284;y,CenterY()+4);
			SongChosenMessageCommand=function(self)
				self:Load(NOTESKIN:GetPathForNoteSkin("_Center","Tap","MQ-SolidColorful"))
				self:pause(true)
				self:visible(true)
			end;
			SongUnchosenMessageCommand=function(self)
				self:visible(false)
			end;
		};
		LoadFont("Common Normal") .. {
			InitCommand=cmd(x,CenterX()-284;y,CenterY()+64+8;zoom,0.8;uppercase,true;maxwidth,320);
			SongChosenMessageCommand=function(self)
				self:settext("Or\nPress [UpLeft] or [UpRight] to Cancel!")
			end;
			SongUnchosenMessageCommand=function(self)
				self:settext("")
			end;
		};
		Def.Sprite{
			InitCommand=cmd(x,CenterX()-284-56;y,CenterY()+64+16*3+8*3;rotationz,135);
			SongChosenMessageCommand=function(self)
				self:Load(NOTESKIN:GetPathForNoteSkin("_Down","Tap","MQ-SolidColorful"))
				self:pause(true)
				self:visible(true)
			end;
			SongUnchosenMessageCommand=function(self)
				self:visible(false)
			end;
		};
		Def.Sprite{
			InitCommand=cmd(x,CenterX()-284+56;y,CenterY()+64+16*3+8*3;rotationz,-135);
			SongChosenMessageCommand=function(self)
				self:Load(NOTESKIN:GetPathForNoteSkin("_Down","Tap","MQ-SolidColorful"))
				self:pause(true)
				self:visible(true)
			end;
			SongUnchosenMessageCommand=function(self)
				self:visible(false)
			end;
		};
	};
end

-- OptionList Names
for PN in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = LoadActor("OpListNames/CommifiedComboNames",PN)
	--t[#t+1] = LoadActor("OpListNames/CustomModsSlotsNames",PN)
	t[#t+1] = LoadActor("OpListNames/FeaturesMenuNames",PN)
	t[#t+1] = LoadActor("OpListNames/NoteSizeNames",PN)
	t[#t+1] = LoadActor("OpListNames/PlayerOptionsNames",PN)
	t[#t+1] = LoadActor("OpListNames/PlayFieldMenuNames",PN)
	t[#t+1] = LoadActor("OpListNames/ScreenFilterNames",PN)
	t[#t+1] = LoadActor("OpListNames/SongMenuNames",PN)
	t[#t+1] = LoadActor("OpListNames/SpeedMenuNames",PN)
	t[#t+1] = LoadActor("OpListNames/SurroundLifeMenuNames",PN)
	t[#t+1] = LoadActor("OpListNames/SurroundLifeNames",PN)
	t[#t+1] = LoadActor("OpListNames/ThemeColorChoiceNames",PN)
	t[#t+1] = LoadActor("OpListNames/ThemeColorDelNames",PN)
	t[#t+1] = LoadActor("OpListNames/ThemeColorLoadNames",PN)
	t[#t+1] = LoadActor("OpListNames/ThemeColorNames",PN)
	t[#t+1] = LoadActor("OpListNames/ThemeColorSaveNames",PN)
end

-- OptionList Titles
for PN in ivalues(GAMESTATE:GetEnabledPlayers()) do
	t[#t+1] = LoadActor("OpListTitles/BackgroundOptionsTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/CustomModsSlotsTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/FeaturesMenuTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/PlayerOptionsTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/PlayFieldMenuTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/SongsListManTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/SongMenuTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/SurroundLifeTitles",PN)
	t[#t+1] = LoadActor("OpListTitles/ThemeColorTitles",PN)
end

if not GAMESTATE:IsCourseMode() then
	t[#t+1] = Def.Quad {
		-- Song Artist/Subtitle Background
		BeginCommand=cmd(draworder,100);
		InitCommand=cmd(x,CenterX();y,Top()+120;zoomto,272,16;valign,0;diffuse,Black();diffusealpha,0.8);
	};

	t[#t+1] = Def.ActorFrame {
		BeginCommand=cmd(draworder,105);
		LoadFont("Common Normal") .. {
			Text="ARTIST:";
			InitCommand=cmd(x,CenterX()-110;y,Top()+120+4;zoom,0.4;valign,0;diffuse,color("#A4A4A4"));
		};
	};
end

return t;